import QtQuick 2.15
import QtQuick.Controls 2.15
import QtQuick.Layouts 1.12
import org.kde.kirigami 2.7 as Kirigami

import io.calamares.core 1.0
import io.calamares.ui 1.0

Item {
    id: root
    width: 800
    height: 600

    // Property für das Passwort
    property string luks_password: ""

    ColumnLayout {
        anchors.centerIn: parent
        spacing: 20

        Label {
            text: qsTr("Set your password for the disk encryption. You must enter this when starting up the PC<br/>
            so that your data can be decrypted.<br/><br/>
            <font color='red'><b>If you lose or forget the password, there is no way to recover your data.</b></font><br/><br/>
            If you skip this step, the password will remain at the non-random default password “86343”.<br/>
            You can also change your LUKS password later in your TUXEDO Control Center (TCC).<br/>")
            font.pixelSize: 16
            Layout.alignment: Qt.AlignHCenter
        }

        TextField {
            id: passwordField
            placeholderText: qsTr("Insert new LUKS password")
            echoMode: showPasswordCheckBox.checked ? TextInput.Normal : TextInput.Password
            Layout.preferredWidth: 300
            onTextChanged: validatePasswords()
            Layout.alignment: Qt.AlignHCenter
        }

        TextField {
            id: confirmPasswordField
            placeholderText: qsTr("Retype new LUKS password")
            echoMode: showPasswordCheckBox.checked ? TextInput.Normal : TextInput.Password
            Layout.preferredWidth: 300
            onTextChanged: validatePasswords()
            Layout.alignment: Qt.AlignHCenter
        }

        CheckBox {
            id: showPasswordCheckBox
            text: "Passwort anzeigen"
            Layout.alignment: Qt.AlignHCenter
        }

        Label {
            id: statusLabel
            text: luks_password.length > 0 ? qsTr("Passwords match") : qsTr("Passwords do not match or no password given")
            color: luks_password.length > 0 ? "green" : "red"
            Layout.alignment: Qt.AlignHCenter
        }
    }

    // Funktion zur Validierung der Passwörter
    function validatePasswords() {
        if (passwordField.text === confirmPasswordField.text && passwordField.text.length > 0) {
            luks_password = passwordField.text
            config.packageChoice = luks_password
        } else {
            luks_password = ""
            config.packageChoice =""
        }
    }
}
