Name:           tuxedo-fix-cuda-suspend
Version:        1.0.2
Release:        1%{?dist}
Summary:        Fixes the availability of cuda after suspend with Nvidia 570 and 580 drivers

License:        GPL-3.0-or-later
URL:            https://gitlab.com/tuxedocomputers/development/packages/fixes/tuxedo-fix-cuda-suspend

BuildArch:      noarch
Requires:       grub2-common
# Place generated rpms into the current directory
%define _rpmdir .

%description
Fixes the availability of cuda after suspend with Nvidia 570 and 580 drivers

%prep
%setup -q

%build

%install
# Copy files to package build root
cp -r  %{_builddir}/files/* %{buildroot}/

%files
%license LICENSE
/usr/share/tuxedo-fixes-grub.d/50-tuxedo-fix-cuda-suspend.cfg

%post
# AUTOMATICALLY GENERATED POST-INSTALL CODE
mkdir -p "$CFG_DIR"

for cfg in "$SRC_DIR"/*-"$DPKG_MAINTSCRIPT_PACKAGE".cfg; do
    [ -f "$cfg" ] || continue
    ln -sf "$cfg" "$CFG_DIR/$(basename "$cfg")"
done

grub-mkconfig -o /boot/grub/grub.cfg "$@"

# END OF AUTOMATICALLY GENERATED POST-INSTALL CODE

%preun
# AUTOMATICALLY GENERATED PRE-REMOVE CODE
for cfg in "$CFG_DIR"/*-"$DPKG_MAINTSCRIPT_PACKAGE".cfg; do
    [ -L "$cfg" ] || continue
    unlink "$cfg"
done

grub-mkconfig -o /boot/grub/grub.cfg "$@"

# END OF AUTOMATICALLY GENERATED PRE-REMOVE CODE

%postun
# AUTOMATICALLY GENERATED POST-REMOVE CODE
# END OF AUTOMATICALLY GENERATED POST-REMOVE CODE

%changelog
* Thu Oct 09 2025 Aaron Erhardt <tux@tuxedocomputers.com> - 1.0.2
- Use simple-package-creator for packaging
* Tue Sep 30 2025 Aaron Erhardt <tux@tuxedocomputers.com> - 1.0.1
- Moved grub configuration files to /usr/share/tuxedo-fixes-grub.d/
- Adapted postinst and postrm scripts accordingly
* Wed Sep 10 2025 Aaron Erhardt <tux@tuxedocomputers.com> - 1.0.0
- Create package
