Name:           tuxedo-fix-i8042-quirks
Version:        1.0.1
Release:        1%{?dist}
Summary:        Adds i8042 kernel parameter to fix issues after suspend

License:        GPL-3.0-or-later
URL:            https://gitlab.com/tuxedocomputers/development/packages/fixes/tuxedo-fix-i8042-quirks

BuildArch:      noarch
Requires:       grub2-common
# Place generated rpms into the current directory
%define _rpmdir .

%description
Adds i8042 kernel parameter to fix issues after suspend

%prep
%setup -q

%build

%install
# Copy files to package build root
cp -r  %{_builddir}/files/* %{buildroot}/

%files
%license LICENSE
/usr/share/tuxedo-fixes-grub.d/50-tuxedo-fix-i8042-quirks.cfg

%post
# AUTOMATICALLY GENERATED POST-INSTALL CODE
mkdir -p "$CFG_DIR"

for cfg in "$SRC_DIR"/*-"$DPKG_MAINTSCRIPT_PACKAGE".cfg; do
    [ -f "$cfg" ] || continue
    ln -sf "$cfg" "$CFG_DIR/$(basename "$cfg")"
done

grub-mkconfig -o /boot/grub/grub.cfg "$@"

# END OF AUTOMATICALLY GENERATED POST-INSTALL CODE

%preun
# AUTOMATICALLY GENERATED PRE-REMOVE CODE
for cfg in "$CFG_DIR"/*-"$DPKG_MAINTSCRIPT_PACKAGE".cfg; do
    [ -L "$cfg" ] || continue
    unlink "$cfg"
done

grub-mkconfig -o /boot/grub/grub.cfg "$@"

# END OF AUTOMATICALLY GENERATED PRE-REMOVE CODE

%postun
# AUTOMATICALLY GENERATED POST-REMOVE CODE
# END OF AUTOMATICALLY GENERATED POST-REMOVE CODE

%changelog
* Fri Oct 10 2025 Aaron Erhardt <tux@tuxedocomputers.com> - 1.0.1
- Use simple-package-creator for packaging
* Fri Feb 14 2025 Steven Seifried <tux@tuxedocomputers.com> - 1.0.0
- Add grub.d file for i8042 quirks.
