Name:           tuxedo-fix-kvm-virt-at-load
Version:        1.0.3
Release:        1%{?dist}
Summary:        Prevents kvm modules from load at boot. Adds `kvm.enable_virt_at_load=0` as kernel parameter.

License:        GPL-3.0-or-later
URL:            https://gitlab.com/tuxedocomputers/development/packages/fixes/tuxedo-fix-kvm-virt-at-load

BuildArch:      noarch
Requires:       grub2-common
# Place generated rpms into the current directory
%define _rpmdir .

%description
Prevents kvm modules from load at boot. Adds `kvm.enable_virt_at_load=0` as kernel parameter.

%prep
%setup -q

%build

%install
# Copy files to package build root
cp -r  %{_builddir}/files/* %{buildroot}/

%files
%license LICENSE
/usr/share/tuxedo-fixes-grub.d/50-tuxedo-fix-kvm-virt-at-load.cfg

%post
# AUTOMATICALLY GENERATED POST-INSTALL CODE
mkdir -p "$CFG_DIR"

for cfg in "$SRC_DIR"/*-"$DPKG_MAINTSCRIPT_PACKAGE".cfg; do
    [ -f "$cfg" ] || continue
    ln -sf "$cfg" "$CFG_DIR/$(basename "$cfg")"
done

grub-mkconfig -o /boot/grub/grub.cfg "$@"

# END OF AUTOMATICALLY GENERATED POST-INSTALL CODE

%preun
# AUTOMATICALLY GENERATED PRE-REMOVE CODE
for cfg in "$CFG_DIR"/*-"$DPKG_MAINTSCRIPT_PACKAGE".cfg; do
    [ -L "$cfg" ] || continue
    unlink "$cfg"
done

grub-mkconfig -o /boot/grub/grub.cfg "$@"

# END OF AUTOMATICALLY GENERATED PRE-REMOVE CODE

%postun
# AUTOMATICALLY GENERATED POST-REMOVE CODE
# END OF AUTOMATICALLY GENERATED POST-REMOVE CODE

%changelog
* Wed Oct 29 2025 Aaron Erhardt <tux@tuxedocomputers.com> - 1.0.3
- Fix package description
* Fri Oct 10 2025 Aaron Erhardt <tux@tuxedocomputers.com> - 1.0.2
- Use simple-package-creator for packaging
* Mon Sep 08 2025 Torsten Wohlfarth <tux@tuxedocomputers.com> - 1.0.1
- Add grub.d file for kvm.enable_virt_at_load=0.
* Thu Aug 28 2025 Torsten Wohlfarth <tux@tuxedocomputers.com> - 1.0.0
- Fix debian/postrm
