Name:           tuxedo-fix-nvidia-preserve-vram-suspend
Version:        1.0.5
Release:        1%{?dist}
Summary:        Fixes graphic glitches/problems with VRAM after suspend.

License:        GPL-3.0-or-later
Group:          Development
Packager:       TUXEDO Computers GmbH <tux@tuxedocomputers.com>
URL:            https://gitlab.com/tuxedocomputers/development/packages/fixes/tuxedo-fix-nvidia-preserve-vram-suspend

source0:        https://gitlab.com/tuxedocomputers/development/packages/fixes/tuxedo-fix-nvidia-preserve-vram-suspend/releases/%{name}-%{version}.tar.gz

BuildArch:      noarch
Requires:       grub2-common

%description
Fixes graphic glitches/problems with VRAM after suspend.

Adds `nvidia.NVreg_PreserveVideoMemoryAllocations=1` and
`nvidia.NVreg_TemporaryFilePath=/var/tmp` as Kernel Parameters

%prep
%setup -q

%build

%install
# Copy files to package build root
cp -r files/* %{buildroot}/

%files
%license LICENSE
/usr/share/tuxedo-fix-nvidia-preserve-vram-suspend/grub.d/50-tuxedo-fix-nvidia-preserve-vram-suspend.cfg
/usr/share/applications/tuxedo-fix-nvidia-preserve-vram-suspend.desktop
/usr/share/icons/hicolor/64x64/apps/tuxedo-fix-nvidia-preserve-vram-suspend.png
/usr/share/metainfo/tuxedo-fix-nvidia-preserve-vram-suspend.metainfo.xml


%post
# AUTOMATICALLY GENERATED POST-INSTALL CODE

GRUB_SRC_DIR=/usr/share/tuxedo-fix-nvidia-preserve-vram-suspend/grub.d
GRUB_CFG_DIR=/etc/default/grub.d

mkdir -p "$GRUB_CFG_DIR"

for cfg in "$GRUB_SRC_DIR"/*-"tuxedo-fix-nvidia-preserve-vram-suspend".cfg; do
    [ -f "$cfg" ] || continue
    ln -sf "$cfg" "$GRUB_CFG_DIR/$(basename "$cfg")"
done

if [ "$(stat -c %d:%i /)" != "$(stat -c %d:%i /proc/1/root/.)" ]; then
    echo "Running in chroot, do nothing."
else
    grub-mkconfig -o /boot/grub/grub.cfg "$@"
fi



# END OF AUTOMATICALLY GENERATED POST-INSTALL CODE


%preun
# AUTOMATICALLY GENERATED PRE-REMOVE CODE
GRUB_CFG_DIR=/etc/default/grub.d

for cfg in "$GRUB_CFG_DIR"/*-"tuxedo-fix-nvidia-preserve-vram-suspend".cfg; do
    [ -L "$cfg" ] || continue
    unlink "$cfg"
done

if [ "$(stat -c %d:%i /)" != "$(stat -c %d:%i /proc/1/root/.)" ]; then
    echo "Running in chroot, do nothing."
else
    grub-mkconfig -o /boot/grub/grub.cfg "$@"
fi

# END OF AUTOMATICALLY GENERATED PRE-REMOVE CODE



%changelog
* Mon Nov 17 2025 Aaron Erhardt <tux@tuxedocomputers.com> - 1.0.5-1
- Don't update grub during installation when in chroot
* Tue Nov 04 2025 Maximilian Arnold <tux@tuxedocomputers.com> - 1.0.4-1
- Switch name to tuxedo-fix-nvidia-preserve-vram-suspend
* Tue Nov 04 2025 Maximilian Arnold <tux@tuxedocomputers.com> - 1.0.3-1
- Add `nvidia.NVreg_TemporaryFilePath=/var/tmp` to force writing on disk rather than on maybe as RAM mounted /tmp.
* Thu Oct 09 2025 Aaron Erhardt <tux@tuxedocomputers.com> - 1.0.2-1
- Use simple-package-creator for packaging
* Tue Sep 30 2025 Aaron Erhardt <tux@tuxedocomputers.com> - 1.0.1-1
- Moved grub configuration files to /usr/share/tuxedo-fixes-grub.d/
- Adapted postinst and postrm scripts accordingly
* Wed Sep 10 2025 Aaron Erhardt <tux@tuxedocomputers.com> - 1.0.0-1
- Create package
