import pytest
import os
import subprocess

from src.tuxedo_tomte_light.package_manager import DnfManager

if os.environ.get("PM") != "dnf":
    pytest.skip("Skipping dnf tests because PM=dnf not set", allow_module_level=True)

def run(cmd):
    return subprocess.run(cmd, stdout=subprocess.PIPE, stderr=subprocess.PIPE, text=True)


@pytest.mark.parametrize("pkg", ['nano', 'htop'])
def test_dnf_install_reinstalls_removed_package(pkg):
    pm = DnfManager()

    run(["dnf", "-y", "remove", pkg])
    assert run(["rpm", "-q", pkg]).returncode != 0, "Package should be removed"

    pm.install(pkg)

    assert run(["rpm", "-q", pkg]).returncode == 0, "Package should be installed"


@pytest.mark.parametrize("pkg", ['nano', 'htop', 'curl', 'bash'])
def test_dnf_package_exists_matches_ground_truth(pkg):
    pm = DnfManager()

    rc = run(["dnf", "list", pkg]).returncode
    should_exist = rc == 0

    assert pm.package_exists(pkg) == should_exist
