import pytest
import os
import subprocess

from src.tuxedo_tomte_light.package_manager import PacmanManager

if os.environ.get("PM") != "pacman":
    pytest.skip("Skipping pacman tests because PM=pacman not set", allow_module_level=True)

def run(cmd):
    return subprocess.run(cmd, stdout=subprocess.PIPE, stderr=subprocess.PIPE, text=True)


@pytest.mark.parametrize("pkg", ['nano', 'htop'])
def test_pacman_install_reinstalls_removed_package(pkg):
    pm = PacmanManager()

    run(["pacman", "-R", "--noconfirm", pkg])
    assert run(["pacman", "-Q", pkg]).returncode != 0

    pm.install(pkg)

    assert run(["pacman", "-Q", pkg]).returncode == 0


@pytest.mark.parametrize("pkg", ['nano', 'htop', 'curl', 'bash'])
def test_pacman_package_exists_matches_ground_truth(pkg):
    pm = PacmanManager()

    rc = run(["pacman", "-Si", pkg]).returncode
    should_exist = rc == 0

    assert pm.package_exists(pkg) == should_exist
