import pytest
import os
import subprocess

from src.tuxedo_tomte_light.package_manager import ZypperManager

if os.environ.get("PM") != "zypper":
    pytest.skip("Skipping zypper tests because PM=zypper not set", allow_module_level=True)


def run(cmd):
    return subprocess.run(cmd, stdout=subprocess.PIPE, stderr=subprocess.PIPE, text=True)


@pytest.mark.parametrize("pkg", ['nano', 'htop', 'curl'])
def test_zypper_install_reinstalls_removed_package(pkg):
    pm = ZypperManager()

    run(["zypper", "--non-interactive", "remove", pkg])
    assert run(["rpm", "-q", pkg]).returncode != 0

    pm.install(pkg)

    assert run(["rpm", "-q", pkg]).returncode == 0


@pytest.mark.parametrize("pkg", ['nano', 'htop', 'curl', 'bash'])
def test_zypper_package_exists_matches_ground_truth(pkg):
    pm = ZypperManager()

    rc = run(["zypper", "search", "--match-exact", pkg]).returncode
    should_exist = rc == 0

    assert pm.package_exists(pkg) == should_exist
