import logging
import os
import sys

class MaxLevelFilter(logging.Filter):
    """Filter allowing only log records with level <= max_level."""
    def __init__(self, max_level):
        super().__init__()
        self.max_level = max_level

    def filter(self, record):
        return record.levelno <= self.max_level


def setup_logging():
    logger = logging.getLogger("TUXEDO Tomte-Light")
    log_level_str = os.getenv("TOMTE_LIGHT_LOG_LEVEL", "INFO").upper()
    log_level = getattr(logging, log_level_str, logging.INFO)

    logger.setLevel(log_level)
    logger.propagate = False

    if logger.handlers:
        logger.handlers.clear()

    formatter = logging.Formatter(
        fmt="[{asctime}] {levelname:<8} {name}: {message}",
        datefmt="%Y-%m-%d %H:%M:%S",
        style="{",
    )

    # -------------------------
    # STDOUT-Handler: DEBUG + INFO
    # -------------------------
    stdout_handler = logging.StreamHandler(sys.stdout)
    stdout_handler.setLevel(logging.DEBUG)
    stdout_handler.addFilter(MaxLevelFilter(logging.INFO))  # bis INFO
    stdout_handler.setFormatter(formatter)

    # -------------------------
    # STDERR-Handler: WARNING, ERROR, CRITICAL
    # -------------------------
    stderr_handler = logging.StreamHandler(sys.stderr)
    stderr_handler.setLevel(logging.WARNING)
    stderr_handler.setFormatter(formatter)

    logger.addHandler(stdout_handler)
    logger.addHandler(stderr_handler)

    return logger


logger = setup_logging()
