# Don't ship debug info (of Rust packages for example)
%define debug_package %{nil}
# Define macro used on OpenSUSE for other RPM distros
%{!?python_flavor: %global python_flavor python3}

Name:           tuxedo-tomte-light
Version:        0.2.0
Release:        1%{?dist}
Summary:        Little helper service for updates and fixes for TUXEDO devices

License:        GPL-3.0-or-later
Group:          Development
Packager:       TUXEDO Computers GmbH <tux@tuxedocomputers.com>
URL:            https://gitlab.com/tuxedocomputers/development/packages/tuxedo-tomte-light

source0:        https://gitlab.com/tuxedocomputers/development/packages/tuxedo-tomte-light/releases/%{name}-%{version}.tar.gz

BuildArch:      noarch

# OpenSUSE requires additional rpm macros to find the default Python version
%if 0%{?suse_version} > 1600
BuildRequires:  python-rpm-macros
%endif
%if 0%{?suse_version} > 1600
# Dependencies on OpenSUSE can be case-insensitive
Requires:       %{python_flavor}, %{python_flavor}-PyYAML, systemd
%else
Requires:       %{python_flavor}, %{python_flavor}-pyyaml, systemd
%endif

%description
Little helper service for updates and fixes for TUXEDO devices

TUXEDO Tomte Light is a modern, cross-distribution configuration tool designed
to apply TUXEDO Fix Packages and Board Packages in a consistent, testable, and
automated manner across multiple Linux distributions. Its primary focus is
multi-distro support, WebFAI integration, and a minimal, well-defined CLI.

%prep
%setup -q

%build

%install
# Copy files to package build root
cp -r files/* %{buildroot}/

%files
%license LICENSE
/usr/share/man/man1/tuxedo-tomte-light.1.gz
/usr/lib/tuxedo-tomte-light/base.yaml
/usr/lib/tuxedo-tomte-light/package_mapper.yaml
/usr/lib/tuxedo-tomte-light/tuxedo-os.yaml
/usr/lib/tuxedo-tomte-light/tuxedo-devices.yaml
/usr/lib/systemd/system/tuxedo-tomte-light.service
/usr/lib/systemd/system/tuxedo-tomte-light.timer
/usr/share/applications/tuxedo-tomte-light.desktop
/usr/share/icons/hicolor/64x64/apps/tuxedo-tomte-light.png
/usr/share/metainfo/tuxedo-tomte-light.metainfo.xml
/usr/bin/tuxedo-tomte-light
/usr/lib/python3/dist-packages/__init__.py
/usr/lib/python3/dist-packages/tests/__init__.py
/usr/lib/python3/dist-packages/tests/integration/__init__.py
/usr/lib/python3/dist-packages/tests/integration/package_manager/__init__.py
/usr/lib/python3/dist-packages/tests/integration/package_manager/test_apt_methods.py
/usr/lib/python3/dist-packages/tests/integration/package_manager/test_base_methods.py
/usr/lib/python3/dist-packages/tests/integration/package_manager/test_dnf_methods.py
/usr/lib/python3/dist-packages/tests/integration/package_manager/test_pacman_methods.py
/usr/lib/python3/dist-packages/tests/integration/package_manager/test_zypper_methods.py
/usr/lib/python3/dist-packages/tests/unit/__init__.py
/usr/lib/python3/dist-packages/tests/unit/test_config_mapping.py
/usr/lib/python3/dist-packages/tests/unit/test_hardware_parsing.py
/usr/lib/python3/dist-packages/tests/unit/test_state_manager.py
/usr/lib/python3/dist-packages/tests/unit/package_mapper/__init__.py
/usr/lib/python3/dist-packages/tests/unit/package_mapper/test_match_ids.py
/usr/lib/python3/dist-packages/tuxedo_tomte_light/__init__.py
/usr/lib/python3/dist-packages/tuxedo_tomte_light/__main__.py
/usr/lib/python3/dist-packages/tuxedo_tomte_light/board_manager.py
/usr/lib/python3/dist-packages/tuxedo_tomte_light/config_parser.py
/usr/lib/python3/dist-packages/tuxedo_tomte_light/fatal_checks.py
/usr/lib/python3/dist-packages/tuxedo_tomte_light/file_operations.py
/usr/lib/python3/dist-packages/tuxedo_tomte_light/hardware_parser.py
/usr/lib/python3/dist-packages/tuxedo_tomte_light/logging.py
/usr/lib/python3/dist-packages/tuxedo_tomte_light/package_manager.py
/usr/lib/python3/dist-packages/tuxedo_tomte_light/package_mapper.py
/usr/lib/python3/dist-packages/tuxedo_tomte_light/state_manager.py
/usr/lib/python3/dist-packages/tuxedo_tomte_light/tuxedo_detection.py
/usr/lib/python3/dist-packages/tuxedo_tomte_light/update_hardware_information.py
/usr/lib/python3/dist-packages/tuxedo_tomte_light-0.2.0.dist-info/METADATA
/usr/lib/python3/dist-packages/tuxedo_tomte_light-0.2.0.dist-info/WHEEL
/usr/lib/python3/dist-packages/tuxedo_tomte_light-0.2.0.dist-info/top_level.txt
/usr/lib/python3/dist-packages/tuxedo_tomte_light-0.2.0.dist-info/RECORD


%post
# AUTOMATICALLY GENERATED POST-INSTALL CODE

systemctl daemon-reload
systemctl enable --now tuxedo-tomte-light.timer

# END OF AUTOMATICALLY GENERATED POST-INSTALL CODE


%preun
# AUTOMATICALLY GENERATED PRE-REMOVE CODE

# Stop all units
systemctl stop tuxedo-tomte-light.service
systemctl stop tuxedo-tomte-light.timer
# Disable all enabled units
systemctl disable tuxedo-tomte-light.timer
# END OF AUTOMATICALLY GENERATED PRE-REMOVE CODE


%postun
# AUTOMATICALLY GENERATED POST-REMOVE CODE
systemctl daemon-reload

# END OF AUTOMATICALLY GENERATED POST-REMOVE CODE


%changelog
* Thu Dec 04 2025 Maximilian Arnold <tux@tuxedocomputers.com> - 0.2.0-1
- Add full functionality
* Fri Nov 07 2025 Aaron Erhardt <tux@tuxedocomputers.com> - 0.1.0-1
- Initial packaging
