import argparse
import logging
from argparse import Namespace

from .state_manager import reset_installed_state

logger = logging.getLogger(__name__)
startup_logger = logging.getLogger(f"{__name__.split('.', 1)[0]}.startup")


def parse_args() -> Namespace:
    parser = argparse.ArgumentParser()
    parser.add_argument(
        "--reset", action="store_true", help="Delete all stored installation flags"
    )
    parser.add_argument(
        "--force",
        action="store_true",
        help="Delete all stored installation flags and start",
    )
    args = parser.parse_args()
    startup_logger.info(
        "Started tuxedo-tomte-light with args: %s",
        " ".join(f"{k}={v}" for k, v in vars(args).items()),
    )

    return args


def execute_flags_and_check_return_necessary(args: Namespace) -> bool:
    if args.reset or args.force:
        logger.info("Resetting installation state...")

        # exit on failure
        if not reset_installed_state():
            return True

        # exit only on reset and not on force
        if args.reset:
            return True

    return False
