import fcntl
import logging
import os
import sys
import urllib.request
from typing import NoReturn

startup_logger = logging.getLogger("startup")
logger = logging.getLogger(__name__)
LOCKFILE = "/run/lock/tomte-light.lock"

TEST_URLS = [
    "https://1.1.1.1/",  # Cloudflare (DNS + CDN)
    "https://8.8.8.8/",  # Google DNS
    "https://deb.debian.org/",  # Debian
    "https://tuxedocomputers.com/",  # TUXEDO
]


def tomte_light_exit(code: int) -> NoReturn:
    startup_logger.info("Exited tomte-light with code: " + str(code))
    sys.exit(code)


def check_internet(timeout: int = 3) -> None:
    for url in TEST_URLS:
        try:
            urllib.request.urlopen(url, timeout=timeout)
            return
        except Exception:
            continue

    logger.critical("No network connection found.")
    tomte_light_exit(1)


def check_single_instance_lock() -> None:
    lock_fd = os.open(LOCKFILE, os.O_RDWR | os.O_CREAT, 0o600)
    try:
        fcntl.lockf(lock_fd, fcntl.LOCK_EX | fcntl.LOCK_NB)
    except OSError:
        logger.critical("Another instance of tomte-light is already running.")
        tomte_light_exit(1)


def check_root_priviliges() -> None:
    if os.geteuid() != 0:
        logger.critical(
            "No root priviliges detected. Please execute with `sudo` or as root."
        )
        tomte_light_exit(1)


def check_fatals() -> None:
    check_root_priviliges()
    check_single_instance_lock()
    check_internet()
