# Don't ship debug info (of Rust packages for example)
%define debug_package %{nil}

Name:           tuxedo-yt6801
Version:        1.0.30~tux6
Release:        1%{?dist}
Summary:        A driver for the Motorcomm YT6801 Ethernet controller

License:        GPL-3.0-or-later
Group:          Development
Packager:       TUXEDO Computers GmbH <tux@tuxedocomputers.com>
URL:            https://gitlab.com/tuxedocomputers/development/packages/tuxedo-yt6801

source0:        https://gitlab.com/tuxedocomputers/development/packages/tuxedo-yt6801/releases/%{name}-%{version}.tar.gz

BuildArch:      noarch

Requires:       dkms

%description
A driver for the Motorcomm YT6801 Ethernet controller

Driver for Motorcomm YT6801

%prep
%setup -q

%build

%install
# Copy files to package build root
cp -r files/* %{buildroot}/

%files
%license LICENSE
/usr/src/tuxedo-yt6801-1.0.30~tux6/fuxi-gmac-ioctl.c
/usr/src/tuxedo-yt6801-1.0.30~tux6/Notice.txt
/usr/src/tuxedo-yt6801-1.0.30~tux6/fuxi-gmac-pci.c
/usr/src/tuxedo-yt6801-1.0.30~tux6/fuxi-gmac-reg.h
/usr/src/tuxedo-yt6801-1.0.30~tux6/fuxi-efuse.c
/usr/src/tuxedo-yt6801-1.0.30~tux6/fuxi-errno.h
/usr/src/tuxedo-yt6801-1.0.30~tux6/Kbuild_default
/usr/src/tuxedo-yt6801-1.0.30~tux6/fuxi-dbg.h
/usr/src/tuxedo-yt6801-1.0.30~tux6/fuxi-gmac-phy.c
/usr/src/tuxedo-yt6801-1.0.30~tux6/fuxi-gmac-hw.c
/usr/src/tuxedo-yt6801-1.0.30~tux6/fuxi-gmac.h
/usr/src/tuxedo-yt6801-1.0.30~tux6/fuxi-gmac-desc.c
/usr/src/tuxedo-yt6801-1.0.30~tux6/fuxi-os.h
/usr/src/tuxedo-yt6801-1.0.30~tux6/fuxi-gmac-ethtool.c
/usr/src/tuxedo-yt6801-1.0.30~tux6/fuxi-gmac-net.c
/usr/src/tuxedo-yt6801-1.0.30~tux6/Kbuild_no_aspm
/usr/src/tuxedo-yt6801-1.0.30~tux6/fuxi-efuse.h
/usr/src/tuxedo-yt6801-1.0.30~tux6/fuxi-gmac-common.c
/usr/src/tuxedo-yt6801-1.0.30~tux6/dkms.conf
/usr/share/applications/tuxedo-yt6801.desktop
/usr/share/icons/hicolor/64x64/apps/tuxedo-yt6801.png
/usr/share/metainfo/tuxedo-yt6801.metainfo.xml



%post
SPC_PKG_NAME="tuxedo-yt6801"
SPC_PKG_VERSION="1.0.30~tux6"

board_name="$(cat /sys/class/dmi/id/board_name)"
base_path="/usr/src/$SPC_PKG_NAME-$SPC_PKG_VERSION"

if [ "GXxHRXx" = "$board_name" ] || [ "GM5IXxA" = "$board_name" ]; then
    target="Kbuild_no_aspm"
else
    target="Kbuild_default"
fi

ln -s $base_path/$target \
    $base_path/Kbuild


# AUTOMATICALLY GENERATED POST-INSTALL CODE




# Run postinstall logic on debian
if [ -f /usr/lib/dkms/common.postinst ]; then
	/usr/lib/dkms/common.postinst tuxedo-yt6801 1.0.30~tux6 \
	    /usr/share/tuxedo-yt6801-dkms "" $2
elif [ -z "$RPM_OS" ]; then
    dkms add -m tuxedo-yt6801 -v 1.0.30~tux6 --rpm_safe_upgrade
    dkms build -m tuxedo-yt6801 -v 1.0.30~tux6
    dkms install -m tuxedo-yt6801 -v 1.0.30~tux6
fi

# END OF AUTOMATICALLY GENERATED POST-INSTALL CODE


%preun
SPC_PKG_NAME="tuxedo-yt6801"
SPC_PKG_VERSION="1.0.30~tux6"

base_path="/usr/src/$SPC_PKG_NAME-$SPC_PKG_VERSION"
unlink $base_path/Kbuild || true


# AUTOMATICALLY GENERATED PRE-REMOVE CODE



if [ -f /usr/lib/dkms/common.postinstall ]; then
    if [  "$(dkms status -m tuxedo-yt6801 -v 1.0.30~tux6)" ]; then
        dkms remove -m tuxedo-yt6801 -v 1.0.30~tux6 --all
    fi
elif [ -z "$RPM_OS" ]; then
    dkms remove -m tuxedo-yt6801 -v 1.0.30~tux6 --all --rpm_safe_upgrade
fi

# END OF AUTOMATICALLY GENERATED PRE-REMOVE CODE



%changelog
* Thu Jan 29 2026 Aaron Erhardt <tux@tuxedocomputers.com> - 1.0.30~tux6-1
- fix: disable aspm on problematic devices
* Mon Nov 03 2025 Werner Sembach <tux@tuxedocomputers.com> - 1.0.30~tux5-1
- fix: remove outdated quirk for RHEL 7
* Tue Aug 26 2025 Werner Sembach <tux@tuxedocomputers.com> - 1.0.30~tux4-1
- reverte idle power fix with race problems
- fix idle power consumption
* Thu Aug 21 2025 Werner Sembach <tux@tuxedocomputers.com> - 1.0.30~tux3-1
- Apply function rename to fix compile error with kernel 6.16 and newer
* Wed Jul 16 2025 Tuxedo BOT <tux@tuxedocomputers.com> - 1.0.30~tux2-1
- Dynamically switch power mode on some devices for lower idle power draw
* Thu Jun 12 2025 Tuxedo BOT <tux@tuxedocomputers.com> - 1.0.30~tux1-1
- Update source to 1.0.30 from upstream
- Update Makefile
- Fix compile error with linux kernel >= v6.15
* Tue Mar 25 2025 Werner Sembach <tux@tuxedocomputers.com> - 1.0.29~tux1-1
- Fix wrong name in Makefile
- Fix compile error because of bogus debug print define
* Wed Aug 28 2024 Werner Sembach <tux@tuxedocomputers.com> - 1.0.29~tux0-1
- Update codebase to 1.0.29
- Convert to native package
* Tue Aug 13 2024 Werner Sembach <tux@tuxedocomputers.com> - 1.0.28~6-1
- Fix install error
* Tue Aug 13 2024 Werner Sembach <tux@tuxedocomputers.com> - 1.0.28~5-1
- Don't print warning for normal behaviour
- Fix rpm
* Tue Aug 13 2024 Maximilian Arnold <tux@tuxedocomputers.com> - 1.0.28~4-1
- Removed reload of the module for chroot environments
* Mon Aug 12 2024 Werner Sembach <tux@tuxedocomputers.com> - 1.0.28~3-1
- Switch build process to Kbuild instead of Makefile
* Wed Jul 31 2024 Christoffer Sandberg <tux@tuxedocomputers.com> - 1.0.28~2-1
- Build fix for kernel version
* Wed Apr 03 2024 Werner Sembach <tux@tuxedocomputers.com> - 1.0.28~1-1
- Initial release.
