/* === This file is part of Calamares - <https://calamares.io> ===
 *
 *   SPDX-FileCopyrightText: 2022 Anke Boersma <demm@kaosx.us>
 *   SPDX-License-Identifier: GPL-3.0-or-later
 * 
 *   Calamares is Free Software: see the License-Identifier above.
 *
 */

import io.calamares.core 1.0
import io.calamares.ui 1.0


import QtQuick 2.15
import QtQuick.Controls 2.15
import QtQuick.Layouts 1.3

Item {
    width: parent.width
    height: parent.height

    property bool isTextVisible: false

    Rectangle {
        anchors.fill: parent
        color: "#f2f2f2"

        ButtonGroup {
            id: switchGroup
        }

        Button {
            id: details
            x: 100
            y: 610
            text: qsTr("Advanced settings (recommended for advanced users)")
            onClicked: {
               isTextVisible = !isTextVisible
               console.log("text visibility:", isTextVisible)
            }
            background: Rectangle {
                width: details.implicitWidth + 40 // Adjust width as needed
                height: details.implicitHeight + 20 // Adjust height as needed
                border.color: parent.pressed ? "transparent" : "white"
                border.width: 1
                color: parent.hovered ? "#e30016" : "#111213"
                anchors.centerIn: parent
            }
            contentItem: Text {
                text: parent.text
                color: "White"
                font.bold: true
                font.pixelSize: 12
                anchors.centerIn: parent
                horizontalAlignment: Text.AlignHCenter
                verticalAlignment: Text.AlignVCenter
            }
       }

       Text {
            text: qsTr("Please select your session type, or leave the default <strong>X11</strong>.<br/>")
            font.pointSize: 12
            anchors.horizontalCenter: parent.horizontalCenter
            anchors.top: parent.top
            anchors.topMargin: 30
            wrapMode: Text.WordWrap
        }

        Column {
            id: column
            anchors.centerIn: parent
            spacing: 5

            Rectangle {

                //id: rectangle
                width: 850
                height: 180
                color: "#ffffff"
                radius: 10
                border.width: 0
                Text {
                    width: 650
                    height: 160
                    anchors.centerIn: parent
                    text: qsTr("<b>X11 - The current standard</b><br>Leave it at our standard selection if you simply want to use your system.<br>")
                    font.pointSize: 10
                    anchors.verticalCenterOffset: 10
                    anchors.horizontalCenterOffset: 90
                    wrapMode: Text.WordWrap
                }

                // Text element that becomes visible when the button is clicked
                Text {
                    width: 650
                    height: 160
                    anchors.centerIn: parent
                    text: qsTr("The X Window System (X11 for short) is the current technical basis for the graphical user interface in TUXEDO OS. However, work is currently underway on the more modern ‘Wayland’ standard. Wayland will replace X11 in the future, but currently still has one or two bugs, which is why we do not yet recommend it as the standard for everyone!")
                    anchors.verticalCenterOffset: 60
                    anchors.horizontalCenterOffset: 90
                    visible: isTextVisible
                    wrapMode: Text.WordWrap
                }

                Switch {
                    id: element2
                    x: 720
                    y: 150
                    width: 187
                    height: 14
                    text: qsTr("X11")
                    checked: true
                    hoverEnabled: true
                    ButtonGroup.group: switchGroup

                    indicator: Rectangle {
                        implicitWidth: 40
                        implicitHeight: 14
                        radius: 10
                        color: element2.checked ? "#3498db" : "#B9B9B9"
                        border.color: element2.checked ? "#3498db" : "#cccccc"

                        Rectangle {
                            x: element2.checked ? parent.width - width : 0
                            y: (parent.height - height) / 2
                            width: 20
                            height: 20
                            radius: 10
                            color: element2.down ? "#cccccc" : "#ffffff"
                            border.color: element2.checked ? (element2.down ? "#3498db" : "#3498db") : "#999999"
                        }
                    }

                    onCheckedChanged: {
                        if ( ! checked ) {
                            print("X11 not used")
                            config.packageChoice = "kwin-wayland"
                        }
                        else {
                            config.packageChoice = "kwin-x11"
                            print( config.packageChoice )
                        }
                    }
                }

                Image {
                    id: image2
                    x: 40
                    y: 30
                    height: 100
                    fillMode: Image.PreserveAspectFit
                    source: "images/x11.png"
                }
            }

            Rectangle {
                width: 850
                height: 180
                radius: 10
                border.width: 0
                visible: isTextVisible
                Text {
                    width: 650
                    height: 190
                    anchors.centerIn: parent
                    text: qsTr("<b>Wayland - The modern replacement for X11</b><br>The Wayland Display Server is a newer standard that will replace the X Window System in the future and promises a more flexible and smoother image rendering (less Tearing, better display of multiple monitors with different resolutions and/or refresh rates). However, there may still be problems, especially on notebooks with NVIDIA® graphics cards.<br/><br/>Don't worry! You can change this setting at any time during system startup on the TUXEDO OS login screen using the buttons at the bottom left.")
                    font.pointSize: 10
                    anchors.verticalCenterOffset: 10
                    anchors.horizontalCenterOffset: 90
                    wrapMode: Text.WordWrap
                    visible: isTextVisible
                }

                Switch {
                    id: element1
                    x: 720
                    y: 150
                    width: 187
                    height: 14
                    text: qsTr("Wayland")
                    checked: false
                    hoverEnabled: true
                    ButtonGroup.group: switchGroup
                    visible: isTextVisible

                    indicator: Rectangle {
                        implicitWidth: 40
                        implicitHeight: 14
                        radius: 10
                        color: element1.checked ? "#3498db" : "#B9B9B9"
                        border.color: element1.checked ? "#3498db" : "#cccccc"

                        Rectangle {
                            x: element1.checked ? parent.width - width : 0
                            y: (parent.height - height) / 2
                            width: 20
                            height: 20
                            radius: 10
                            color: element1.down ? "#cccccc" : "#ffffff"
                            border.color: element1.checked ? (element1.down ? "#3498db" : "#3498db") : "#999999"
                        }
                    }

                    onCheckedChanged: {
                        if ( !checked ) {
                            print("Wayland not used")
                            config.packageChoice = "kwin-x11"
                        } else {
                            config.packageChoice = "kwin-wayland"
                            print(config.packageChoice)
                        }
                    }
                }

                Image {
                    id: image
                    x: 40
                    y: 30
                    height: 100
                    fillMode: Image.PreserveAspectFit
                    source: "images/wayland.png"
                    visible: isTextVisible
                }

            }

        }
    }
    // Setze config.packageChoice auf den Standardwert
    Component.onCompleted: {
        config.packageChoice = "kwin-x11"
    }
}
