/* === This file is part of Calamares - <https://calamares.io> ===
 *
 *   SPDX-FileCopyrightText: 2021 Anke Boersma <demm@kaosx.us>
 *   SPDX-License-Identifier: GPL-3.0-or-later
 *
 *   Calamares is Free Software: see the License-Identifier above.
 *
 */

import io.calamares.core 1.0
import io.calamares.ui 1.0

import QtQuick 2.15
import QtQuick.Controls 2.15
import QtQuick.Layouts 1.3

Item {
    width:  parent.width
    height: parent.height

    Rectangle {
        anchors.fill: parent
        color: "#f2f2f2"

        ButtonGroup {
            id: switchGroup
        }

        Column {
            id: column
            anchors.centerIn: parent
            spacing: 5

            Rectangle {
                //id: rectangle
                width: 800
                height: 250
                color: "#ffa65d"
                radius: 10
                border.width: 0
                Text {
                    width: 650
                    height: 104
                    anchors.centerIn: parent
                    text: qsTr("<h3>Attention</h3><br><p>Please carry out the initial setup completely and without interruption. The computer is only fully functional after a restart at the end of the setup. Please make sure that the computer has enough battery charge. If in doubt, connect it to the mains. A LAN connection is an advantage.<br><br>If you do not wish to carry out the setup at this time, please shut down the system using the switch symbol at the bottom left.</p>")
                    font.pointSize: 12
                    anchors.verticalCenterOffset: -60
                    anchors.horizontalCenterOffset: 50
                    wrapMode: Text.WordWrap
                }

                Image {
                    id: image2
                    x: 8
                    y: 25
                    height: 100
                    fillMode: Image.PreserveAspectFit
                    source: "images/important.png"
                }
            }

            Rectangle {
                width: 700
                height: 10
                color: "#f2f2f2"
                radius: 10
                border.width: 0

                Switch {
                    id: element3
                    x: 500
                    y: 110
                    width: 187
                    height: 14
                    text: qsTr("")
                    checked: false
                    hoverEnabled: true
                    ButtonGroup.group: switchGroup

                    indicator: Rectangle {
                        implicitWidth: 40
                        implicitHeight: 14
                        radius: 10
                        color: element3.checked ? "#f2f2f2" : "#f2f2f2"
                        border.color: element3.checked ? "#f2f2f2" : "#f2f2f2"

                        Rectangle {
                            x: element3.checked ? parent.width - width : 0
                            y: (parent.height - height) / 2
                            width: 20
                            height: 20
                            radius: 10
                            color: element3.down ? "#f2f2f2" : "#f2f2f2"
                            border.color: element3.checked ? (element3.down ? "#f2f2f2" : "#f2f2f2") : "#f2f2f2"
                        }
                    }

                    onCheckedChanged: {
                        if ( checked ) {
                            config.packageChoice = "minimal_install"
                        }
                    }
                }

            }
        }
    }

}
