/* === This file is part of Calamares - <https://calamares.io> ===
 *
 *   SPDX-FileCopyrightText: 2022 Anke Boersma <demm@kaosx.us>
 *   SPDX-License-Identifier: GPL-3.0-or-later
 * 
 *   Calamares is Free Software: see the License-Identifier above.
 *
 */

import io.calamares.core 1.0
import io.calamares.ui 1.0


import QtQuick 2.15
import QtQuick.Controls 2.15
import QtQuick.Layouts 1.3

Item {
    width: parent.width
    height: parent.height

    Rectangle {
        anchors.fill: parent
        color: "#f2f2f2"

        ButtonGroup {
            id: switchGroup
        }

       Text {
            text: qsTr("Please select your session type or keep our default setting.<br/>")
            font.pointSize: 12
            anchors.horizontalCenter: parent.horizontalCenter
            anchors.top: parent.top
            anchors.topMargin: 30
            wrapMode: Text.WordWrap
        }

        Column {
            id: column
            anchors.centerIn: parent
            spacing: 5

            Rectangle {

                id: rectangle
                width: 850
                height: 230
                color: "#ffffff"
                radius: 10
                border.width: 0
                Text {
                    width: 650
                    height: 210
                    anchors.centerIn: parent
                    text: qsTr("<b>Wayland</b><br><br>Wayland is a modern replacement for X11. It has a simpler structure, is faster and more secure because it communicates directly with the graphics hardware and avoids unnecessary intermediate layers. However, it is not yet fully supported by all programs, which is why some users continue to use X11.<br><br>In a Wayland session, dGPU mode does not work; the system is always in on-demand mode. You will find instructions on how to use the dGPU as a link on your desktop.")
                    anchors.verticalCenterOffset: 5
                    anchors.horizontalCenterOffset: 90
                    wrapMode: Text.WordWrap
                }

                Switch {
                    id: element2
                    x: 720
                    y: 190
                    width: 187
                    height: 14
                    text: qsTr("Wayland")
                    checked: false
                    hoverEnabled: true
                    ButtonGroup.group: switchGroup

                    indicator: Rectangle {
                        implicitWidth: 40
                        implicitHeight: 14
                        radius: 10
                        color: element2.checked ? "#3498db" : "#B9B9B9"
                        border.color: element2.checked ? "#3498db" : "#cccccc"

                        Rectangle {
                            x: element2.checked ? parent.width - width : 0
                            y: (parent.height - height) / 2
                            width: 20
                            height: 20
                            radius: 10
                            color: element2.down ? "#cccccc" : "#ffffff"
                            border.color: element2.checked ? (element2.down ? "#3498db" : "#3498db") : "#999999"
                        }
                    }

                    onCheckedChanged: {
                        if ( ! checked ) {
                            print("Wayland not used")
                            config.packageChoice = "kwin-x11"
                        }
                        else {
                            config.packageChoice = "kwin-wayland"
                            print( config.packageChoice )
                        }
                    }
                }

                Image {
                    id: image2
                    x: 40
                    y: 30
                    height: 100
                    fillMode: Image.PreserveAspectFit
                    source: "images/wayland.png"
                }
            }

            Rectangle {
                width: 850
                height: 230
                radius: 10
                border.width: 0
                Text {
                    width: 650
                    height: 210
                    anchors.centerIn: parent
                    text: qsTr("<b>The X Window System (X11 for short)</b><br><br>X11 (or X Window System) is an older system that has been used in Linux for decades to display graphical content. It acts as an intermediary between programs and graphics hardware, but is very complex and has many old components that often compromise performance and security.<br><br>X11 is sometimes unstable on modern hardware and can be prone to freezing. Therefore, please only use it, if you are concerned about problems with Wayland or if it is preselected here.")
                    font.pointSize: 10
                    anchors.verticalCenterOffset: 10
                    anchors.horizontalCenterOffset: 90
                    wrapMode: Text.WordWrap
                }

                Switch {
                    id: element1
                    x: 720
                    y: 190
                    width: 187
                    height: 14
                    text: qsTr("X11")
                    checked: true
                    hoverEnabled: true
                    ButtonGroup.group: switchGroup

                    indicator: Rectangle {
                        implicitWidth: 40
                        implicitHeight: 14
                        radius: 10
                        color: element1.checked ? "#3498db" : "#B9B9B9"
                        border.color: element1.checked ? "#3498db" : "#cccccc"

                        Rectangle {
                            x: element1.checked ? parent.width - width : 0
                            y: (parent.height - height) / 2
                            width: 20
                            height: 20
                            radius: 10
                            color: element1.down ? "#cccccc" : "#ffffff"
                            border.color: element1.checked ? (element1.down ? "#3498db" : "#3498db") : "#999999"
                        }
                    }

                    onCheckedChanged: {
                        if ( !checked ) {
                            print("X11 not used")
                            config.packageChoice = "kwin-wayland"
                        } else {
                            config.packageChoice = "kwin-x11"
                            print(config.packageChoice)
                        }
                    }
                }

                Image {
                    id: image
                    x: 40
                    y: 30
                    height: 100
                    fillMode: Image.PreserveAspectFit
                    source: "images/x11.png"
                }

            }

        }
    }
    // Setze config.packageChoice auf den Standardwert
    Component.onCompleted: {
        config.packageChoice = "kwin-x11"
    }
}
