#!/usr/bin/env python3
# -*- coding: utf-8 -*-
#
# === This file is part of Calamares - <http://github.com/calamares> ===
#
#   Copyright 2014-2024, Anke Boersma <demm@kaosx.us>
#
#   Calamares is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   Calamares is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with Calamares. If not, see <http://www.gnu.org/licenses/>.

import os
import shutil
import re
import subprocess

import libcalamares


def run():
    """ Configure Plasma Session Type """
    install_path = libcalamares.globalstorage.value("rootMountPoint")

    # Packagechooser@session outcome set to x11 or wayland
    session = libcalamares.globalstorage.value("packagechooser_session")

    if session == 'kwin-wayland':
        #libcalamares.utils.target_env_call(['cp', '-f', '/usr/share/tuxedo/10-wayland.conf', '/etc/sddm.conf.d/'])
        print('Wayland selected')
        if os.path.exists(os.path.join(install_path, 'var/lib/sddm/state.conf')):
              rfile = '/var/lib/sddm/state.conf'
              libcalamares.utils.target_env_call(['/bin/rm', '-f', '%s' % (rfile)])
        if os.path.exists(os.path.join(install_path, 'etc/sddm.conf')):
              print('ändere /etc/sddm.conf')
              sddm_conf_path = os.path.join(install_path, "etc/sddm.conf")
              text = []
              with open(sddm_conf_path, 'r') as sddm_conf:
                  text = sddm_conf.readlines()
              with open(sddm_conf_path, 'w') as sddm_conf:
                  for line in text:
                      if re.match('Session=plasmax11', line):
                          line = 'Session=plasma\n'
                      sddm_conf.write(line)
        if os.path.exists(os.path.join(install_path, 'etc/sddm.conf.d/kde_settings.conf')):
              print('ändere /etc/sddm.conf.d/kde_settings.conf')
              sddm_conf_path = os.path.join(install_path, "etc/sddm.conf.d/kde_settings.conf")
              text = []
              with open(sddm_conf_path, 'r') as sddm_conf:
                  text = sddm_conf.readlines()
              with open(sddm_conf_path, 'w') as sddm_conf:
                  for line in text:
                      if re.match('Session=plasmax11', line):
                          line = 'Session=plasma\n'
                      sddm_conf.write(line)

    if session == 'kwin-x11':
        print('X11 selected')
        # shutil.copy2(os.path.join(install_path,'/usr/share/tuxedo/state.conf'), os.path.join(install_path, '/var/lib/sddm/'))
        print('kopiere state.conf')
        libcalamares.utils.target_env_call(['cp', '-f', '/usr/share/tuxedo/oemconf/state.conf', '/var/lib/sddm/'])
        if os.path.exists(os.path.join(install_path, 'etc/sddm.conf')):
              print('ändere /etc/sddm.conf')
              sddm_conf_path = os.path.join(install_path, "etc/sddm.conf")
              text = []
              with open(sddm_conf_path, 'r') as sddm_conf:
                  text = sddm_conf.readlines()
              with open(sddm_conf_path, 'w') as sddm_conf:
                  for line in text:
                      if re.match('Session=plasma', line):
                          line = 'Session=plasmax11\n'
                      sddm_conf.write(line)
        if os.path.exists(os.path.join(install_path, 'etc/sddm.conf.d/kde_settings.conf')):
              print('ändere /etc/sddm.conf.d/kde_settings.conf')
              sddm_conf_path = os.path.join(install_path, "etc/sddm.conf.d/kde_settings.conf")
              text = []
              with open(sddm_conf_path, 'r') as sddm_conf:
                  text = sddm_conf.readlines()
              with open(sddm_conf_path, 'w') as sddm_conf:
                  for line in text:
                      if re.match('Session=plasma', line):
                          line = 'Session=plasmax11\n'
                      sddm_conf.write(line)

    libcalamares.utils.target_env_call(
        ['setcap', 'cap_net_raw=ep', '/usr/bin/ping'])

    print('configure session done')

    return None
