# Don't ship debug info (of Rust packages for example)
%define debug_package %{nil}

Name:           tuxedo-fix-amdgpu-disable-psr
Version:        1.0.2
Release:        1%{?dist}
Summary:        Disables PSR in the amdgpu driver

License:        GPL-3.0-or-later
Group:          Development
Packager:       TUXEDO Computers GmbH <tux@tuxedocomputers.com>
URL:            https://gitlab.com/tuxedocomputers/development/packages/fixes/tuxedo-fix-amdgpu-disable-psr

source0:        https://gitlab.com/tuxedocomputers/development/packages/fixes/tuxedo-fix-amdgpu-disable-psr/releases/%{name}-%{version}.tar.gz

BuildArch:      noarch

Requires:       tuxedo-fix-grubd-base-entry, grub2-common

%description
Disables PSR in the amdgpu driver

Adds `amdgpu.dcdebugmask=0x10` as kernel parameter.

%prep
%setup -q

%build

%install
# Copy files to package build root
cp -r files/* %{buildroot}/

%files
%license LICENSE
/usr/share/tuxedo-fix-amdgpu-disable-psr/grub.d/50-tuxedo-fix-amdgpu-disable-psr.cfg
/usr/share/applications/tuxedo-fix-amdgpu-disable-psr.desktop
/usr/share/icons/hicolor/64x64/apps/tuxedo-fix-amdgpu-disable-psr.png
/usr/share/metainfo/tuxedo-fix-amdgpu-disable-psr.metainfo.xml



%post
SPC_PKG_NAME="tuxedo-fix-amdgpu-disable-psr"
SPC_PKG_VERSION="1.0.2"



# AUTOMATICALLY GENERATED POST-INSTALL CODE
# SPC: Autogenerated linking
[ -d "/etc/default/grub.d" ] || mkdir -p "/etc/default/grub.d"
ln -sf "/usr/share/tuxedo-fix-amdgpu-disable-psr/grub.d/50-tuxedo-fix-amdgpu-disable-psr.cfg" "/etc/default/grub.d/50-tuxedo-fix-amdgpu-disable-psr.cfg"

# SPC: Autogenerated grub setup
if command -v grub-mkconfig &> /dev/null; then
    grub-mkconfig -o /boot/grub/grub.cfg
else
    grub2-mkconfig -o /boot/grub2/grub.cfg
fi




# END OF AUTOMATICALLY GENERATED POST-INSTALL CODE


%preun
SPC_PKG_NAME="tuxedo-fix-amdgpu-disable-psr"
SPC_PKG_VERSION="1.0.2"



# AUTOMATICALLY GENERATED PRE-REMOVE CODE
# SPC: Autogenerated unlinking
unlink "/etc/default/grub.d/50-tuxedo-fix-amdgpu-disable-psr.cfg" || true

# SPC: Autogenerated grub update
if command -v grub-mkconfig &> /dev/null; then
    grub-mkconfig -o /boot/grub/grub.cfg
else
    grub2-mkconfig -o /boot/grub2/grub.cfg
fi



# END OF AUTOMATICALLY GENERATED PRE-REMOVE CODE



%changelog
* Wed Dec 03 2025 Aaron Erhardt <tux@tuxedocomputers.com> - 1.0.2-1
- Build packages for multiple distributions
- Add tuxedo-fix-grubd-base-entry as rpm dependency
* Fri Oct 10 2025 Aaron Erhardt <tux@tuxedocomputers.com> - 1.0.1-1
- Use simple-package-creator for packaging
* Fri Feb 14 2025 Steven Seifried, Maximilian Arnold <tux@tuxedocomputers.com> - 1.0.0-1
- Fix name of grub config file
- Fix path of grub config file in debian/postrm
- Fix typos
- Add grub.d file to disable PSR for spcific amdgpus.
