# Don't ship debug info (of Rust packages for example)
%define debug_package %{nil}
# Define macro used on OpenSUSE for other RPM distros
%{!?python_flavor: %global python_flavor python3}

Name:           tuxedo-fix-krackan-point-usb4-suspend
Version:        1.0.2
Release:        1%{?dist}
Summary:        Workaround for suspend problems with krackan point USB4 suspend.

License:        GPL-3.0-or-later
Group:          Development
Packager:       TUXEDO Computers GmbH <tux@tuxedocomputers.com>
URL:            https://gitlab.com/tuxedocomputers/development/packages/fixes/tuxedo-fix-krackan-point-usb4-suspend

source0:        https://gitlab.com/tuxedocomputers/development/packages/fixes/tuxedo-fix-krackan-point-usb4-suspend/releases/%{name}-%{version}.tar.gz

BuildArch:      noarch

%if 0%{?suse_version} > 1600
# Dependencies on OpenSUSE can be case-insensitive
Requires:       grub2-common
%else
Requires:       grub2-common
%endif

%description
Workaround for suspend problems with krackan point USB4 suspend.

Adds `processor.max_cstate=1` as kernel parameter.

%prep
%setup -q

%build

%install
# Copy files to package build root
cp -r files/* %{buildroot}/

%files
%license LICENSE
/usr/share/tuxedo-fix-krackan-point-usb4-suspend/grub.d/50-tuxedo-fix-krackan-point-usb4-suspend.cfg
/usr/share/applications/tuxedo-fix-krackan-point-usb4-suspend.desktop
/usr/share/icons/hicolor/64x64/apps/tuxedo-fix-krackan-point-usb4-suspend.png
/usr/share/metainfo/tuxedo-fix-krackan-point-usb4-suspend.metainfo.xml


%post
# AUTOMATICALLY GENERATED POST-INSTALL CODE

GRUB_SRC_DIR=/usr/share/tuxedo-fix-krackan-point-usb4-suspend/grub.d
GRUB_CFG_DIR=/etc/default/grub.d

mkdir -p "$GRUB_CFG_DIR"

for cfg in "$GRUB_SRC_DIR"/*-"tuxedo-fix-krackan-point-usb4-suspend".cfg; do
    [ -f "$cfg" ] || continue
    ln -sf "$cfg" "$GRUB_CFG_DIR/$(basename "$cfg")"
done

if [ "$(stat -c %d:%i /)" != "$(stat -c %d:%i /proc/1/root/.)" ]; then
    echo "Running in chroot, do nothing."
else
    grub-mkconfig -o /boot/grub/grub.cfg "$@"
fi



# END OF AUTOMATICALLY GENERATED POST-INSTALL CODE


%preun
# AUTOMATICALLY GENERATED PRE-REMOVE CODE
GRUB_CFG_DIR=/etc/default/grub.d

for cfg in "$GRUB_CFG_DIR"/*-"tuxedo-fix-krackan-point-usb4-suspend".cfg; do
    [ -L "$cfg" ] || continue
    unlink "$cfg"
done

if [ "$(stat -c %d:%i /)" != "$(stat -c %d:%i /proc/1/root/.)" ]; then
    echo "Running in chroot, do nothing."
else
    grub-mkconfig -o /boot/grub/grub.cfg "$@"
fi

# END OF AUTOMATICALLY GENERATED PRE-REMOVE CODE



%changelog
* Fri Dec 05 2025 Aaron Erhardt <tux@tuxedocomputers.com> - 1.0.2-1
- Build package for multiple distros
* Fri Oct 10 2025 Aaron Erhardt <tux@tuxedocomputers.com> - 1.0.1-1
- Use simple-package-creator for packaging
* Fri Feb 14 2025 Maximilian Arnold <tux@tuxedocomputers.com> - 1.0.0-1
- Add grub.d file for problems with krackan point USB4 suspend.
