# Don't ship debug info (of Rust packages for example)
%define debug_package %{nil}
# Define macro used on OpenSUSE for other RPM distros
%{!?python_flavor: %global python_flavor python3}

Name:           tuxedo-fix-nvidia-preserve-vram-suspend
Version:        1.0.6
Release:        1%{?dist}
Summary:        Fixes graphic glitches/problems with VRAM after suspend.

License:        GPL-3.0-or-later
Group:          Development
Packager:       TUXEDO Computers GmbH <tux@tuxedocomputers.com>
URL:            https://gitlab.com/tuxedocomputers/development/packages/fixes/tuxedo-fix-nvidia-preserve-vram-suspend

source0:        https://gitlab.com/tuxedocomputers/development/packages/fixes/tuxedo-fix-nvidia-preserve-vram-suspend/releases/%{name}-%{version}.tar.gz

BuildArch:      noarch

%if 0%{?suse_version} > 1600
# Dependencies on OpenSUSE can be case-insensitive
Requires:       grub2-common
%else
Requires:       grub2-common
%endif

%description
Fixes graphic glitches/problems with VRAM after suspend.

Adds `nvidia.NVreg_PreserveVideoMemoryAllocations=1` and
`nvidia.NVreg_TemporaryFilePath=/var/tmp` as Kernel Parameters

%prep
%setup -q

%build

%install
# Copy files to package build root
cp -r files/* %{buildroot}/

%files
%license LICENSE
/usr/share/tuxedo-fix-nvidia-preserve-vram-suspend/grub.d/50-tuxedo-fix-nvidia-preserve-vram-suspend.cfg
/usr/share/applications/tuxedo-fix-nvidia-preserve-vram-suspend.desktop
/usr/share/icons/hicolor/64x64/apps/tuxedo-fix-nvidia-preserve-vram-suspend.png
/usr/share/metainfo/tuxedo-fix-nvidia-preserve-vram-suspend.metainfo.xml


%post
# AUTOMATICALLY GENERATED POST-INSTALL CODE
[ -d "etc/default/grub.d" ] && mkdir -p "/etc/default/grub.d"
ln -sf "/usr/share/tuxedo-fix-nvidia-preserve-vram-suspend/grub.d/50-tuxedo-fix-nvidia-preserve-vram-suspend.cfg" "/etc/default/grub.d/50-tuxedo-fix-nvidia-preserve-vram-suspend.cfg"

grub-mkconfig -o /boot/grub/grub.cfg "$@"


# END OF AUTOMATICALLY GENERATED POST-INSTALL CODE


%preun
# AUTOMATICALLY GENERATED PRE-REMOVE CODE
unlink "/etc/default/grub.d/50-tuxedo-fix-nvidia-preserve-vram-suspend.cfg"

grub-mkconfig -o /boot/grub/grub.cfg "$@"

# END OF AUTOMATICALLY GENERATED PRE-REMOVE CODE



%changelog
* Tue Dec 16 2025 Aaron Erhardt <tux@tuxedocomputers.com> - 1.0.6-1
- Update grub during installation unconditionally
* Mon Nov 17 2025 Aaron Erhardt <tux@tuxedocomputers.com> - 1.0.5-1
- Don't update grub during installation when in chroot
* Tue Nov 04 2025 Maximilian Arnold <tux@tuxedocomputers.com> - 1.0.4-1
- Switch name to tuxedo-fix-nvidia-preserve-vram-suspend
* Tue Nov 04 2025 Maximilian Arnold <tux@tuxedocomputers.com> - 1.0.3-1
- Add `nvidia.NVreg_TemporaryFilePath=/var/tmp` to force writing on disk rather than on maybe as RAM mounted /tmp.
* Thu Oct 09 2025 Aaron Erhardt <tux@tuxedocomputers.com> - 1.0.2-1
- Use simple-package-creator for packaging
* Tue Sep 30 2025 Aaron Erhardt <tux@tuxedocomputers.com> - 1.0.1-1
- Moved grub configuration files to /usr/share/tuxedo-fixes-grub.d/
- Adapted postinst and postrm scripts accordingly
* Wed Sep 10 2025 Aaron Erhardt <tux@tuxedocomputers.com> - 1.0.0-1
- Create package
