# Don't ship debug info (of Rust packages for example)
%define debug_package %{nil}
# Define macro used on OpenSUSE for other RPM distros
%{!?python_flavor: %global python_flavor python3}

Name:           tuxedo-repository
Version:        1.0.0
Release:        1%{?dist}
Summary:        Configuration for automatic setup of TUXEDO package sources.

License:        GPL-3.0-or-later
Group:          Development
Packager:       TUXEDO Computers GmbH <tux@tuxedocomputers.com>
URL:            https://gitlab.com/tuxedocomputers/development/packages/tuxedo-repository

source0:        https://gitlab.com/tuxedocomputers/development/packages/tuxedo-repository/releases/%{name}-%{version}.tar.gz

BuildArch:      noarch

Conflicts:      tuxedo-archive-keyring
Obsoletes:      tuxedo-archive-keyring

%description
Configuration for automatic setup of TUXEDO package sources.

Sets up package mirrors for TUXEDO packages.

%prep
%setup -q

%build

%install
# Copy files to package build root
cp -r files/* %{buildroot}/

%files
%license LICENSE
/usr/share/keyrings/tuxedo-archive-keyring.gpg
/usr/share/tuxedo-repository/tuxedo-computers.sources
/usr/share/applications/tuxedo-repository.desktop
/usr/share/icons/hicolor/64x64/apps/tuxedo-repository.png
/usr/share/metainfo/tuxedo-repository.metainfo.xml


%post
# AUTOMATICALLY GENERATED POST-INSTALL CODE
[ -d "etc/apt/sources.list.d" ] && mkdir -p "/etc/apt/sources.list.d"
ln -sf "/usr/share/tuxedo-repository/tuxedo-computers.sources" "/etc/apt/sources.list.d/tuxedo-computers.sources"



# END OF AUTOMATICALLY GENERATED POST-INSTALL CODE


%preun
# AUTOMATICALLY GENERATED PRE-REMOVE CODE
unlink "/etc/apt/sources.list.d/tuxedo-computers.sources"


# END OF AUTOMATICALLY GENERATED PRE-REMOVE CODE



%changelog
* Fri Dec 12 2025 Aaron Erhardt <tux@tuxedocomputers.com> - 1.0.0-1
- Initial package
