# Don't ship debug info (of Rust packages for example)
%define debug_package %{nil}

Name:           tuxedo-tomte-light
Version:        1.0.0
Release:        1%{?dist}
Summary:        Little helper service for updates and fixes for TUXEDO devices

License:        GPL-3.0-or-later
Group:          Development
Packager:       TUXEDO Computers GmbH <tux@tuxedocomputers.com>
URL:            https://gitlab.com/tuxedocomputers/development/packages/tuxedo-tomte-light

source0:        https://gitlab.com/tuxedocomputers/development/packages/tuxedo-tomte-light/releases/%{name}-%{version}.tar.gz

BuildArch:      x86_64

Requires:       tuxedo-repository, systemd
Recommends:     tuxedo-suite

%description
Little helper service for updates and fixes for TUXEDO devices

TUXEDO Tomte Light is a modern, cross-distribution configuration tool designed
to apply TUXEDO Fix Packages and Board Packages in a consistent, testable, and
automated manner across multiple Linux distributions. Its primary focus is
multi-distro support, WebFAI integration, and a minimal, well-defined CLI.

%prep
%setup -q

%build

%install
# Copy files to package build root
cp -r files/* %{buildroot}/

%files
%license LICENSE
/usr/share/man/man1/tuxedo-tomte-light.1.gz
/usr/lib/tuxedo-tomte-light/tuxedo-os.yaml
/usr/lib/tuxedo-tomte-light/base.yaml
/usr/lib/tuxedo-tomte-light/tuxedo-devices.yaml
/usr/lib/tuxedo-tomte-light/package_mapper.yaml
/usr/lib/systemd/system/tuxedo-tomte-light.service
/usr/lib/systemd/system/tuxedo-tomte-light.timer
/usr/share/applications/tuxedo-tomte-light.desktop
/usr/share/icons/hicolor/64x64/apps/tuxedo-tomte-light.png
/usr/share/metainfo/tuxedo-tomte-light.metainfo.xml
/usr/lib/python3/spc-packages/tuxedo_tomte_light/yaml/reader.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/yaml/loader.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/yaml/parser.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/yaml/constructor.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/yaml/nodes.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/yaml/representer.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/yaml/_yaml.cpython-312-x86_64-linux-gnu.so
/usr/lib/python3/spc-packages/tuxedo_tomte_light/yaml/scanner.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/yaml/serializer.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/yaml/tokens.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/yaml/__init__.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/yaml/events.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/yaml/resolver.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/yaml/emitter.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/yaml/composer.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/yaml/cyaml.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/yaml/error.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/yaml/dumper.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/py.typed
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/root_model.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/functional_serializers.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/json.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/type_adapter.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/typing.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/_migration.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/annotated_handlers.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/fields.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/functional_validators.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/main.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/networks.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/dataclasses.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/experimental/__init__.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/experimental/missing_sentinel.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/experimental/arguments_schema.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/experimental/pipeline.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/errors.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/schema.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/mypy.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/color.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/validators.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/env_settings.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/tools.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/validate_call_decorator.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/config.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/json_schema.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/deprecated/copy_internals.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/deprecated/json.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/deprecated/tools.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/deprecated/config.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/deprecated/__init__.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/deprecated/parse.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/deprecated/decorator.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/deprecated/class_validators.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/version.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/__init__.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/aliases.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/error_wrappers.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/types.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/v1/py.typed
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/v1/json.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/v1/_hypothesis_plugin.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/v1/typing.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/v1/fields.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/v1/main.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/v1/networks.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/v1/dataclasses.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/v1/errors.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/v1/schema.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/v1/mypy.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/v1/color.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/v1/validators.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/v1/env_settings.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/v1/tools.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/v1/config.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/v1/version.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/v1/__init__.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/v1/error_wrappers.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/v1/types.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/v1/parse.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/v1/generics.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/v1/utils.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/v1/decorator.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/v1/datetime_parse.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/v1/class_validators.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/v1/annotated_types.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/parse.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/generics.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/utils.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/decorator.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/datetime_parse.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/class_validators.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/plugin/__init__.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/plugin/_schema_validator.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/plugin/_loader.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/alias_generators.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/warnings.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/_internal/_forward_ref.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/_internal/_docs_extraction.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/_internal/_decorators_v1.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/_internal/_schema_generation_shared.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/_internal/_utils.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/_internal/_repr.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/_internal/_dataclasses.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/_internal/_validators.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/_internal/_known_annotated_metadata.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/_internal/_generics.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/_internal/_discriminated_union.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/_internal/_import_utils.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/_internal/_signature.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/_internal/__init__.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/_internal/_model_construction.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/_internal/_internal_dataclass.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/_internal/_generate_schema.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/_internal/_namespace_utils.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/_internal/_decorators.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/_internal/_typing_extra.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/_internal/_serializers.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/_internal/_mock_val_ser.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/_internal/_core_utils.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/_internal/_validate_call.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/_internal/_fields.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/_internal/_core_metadata.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/_internal/_schema_gather.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/_internal/_config.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic/_internal/_git.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/typing_extensions.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/typing_inspection/py.typed
/usr/lib/python3/spc-packages/tuxedo_tomte_light/typing_inspection/typing_objects.pyi
/usr/lib/python3/spc-packages/tuxedo_tomte_light/typing_inspection/__init__.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/typing_inspection/typing_objects.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/typing_inspection/introspection.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic_core/py.typed
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic_core/_pydantic_core.cpython-312-x86_64-linux-gnu.so
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic_core/core_schema.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic_core/__init__.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/pydantic_core/_pydantic_core.pyi
/usr/lib/python3/spc-packages/tuxedo_tomte_light/annotated_types/py.typed
/usr/lib/python3/spc-packages/tuxedo_tomte_light/annotated_types/test_cases.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/annotated_types/__init__.py
/usr/lib/python3/spc-packages/tuxedo_tomte_light/_yaml/__init__.py
/usr/bin/tuxedo-tomte-light
/usr/lib/python3/dist-packages/tuxedo_tomte_light/__init__.py
/usr/lib/python3/dist-packages/tuxedo_tomte_light/__main__.py
/usr/lib/python3/dist-packages/tuxedo_tomte_light/args_management.py
/usr/lib/python3/dist-packages/tuxedo_tomte_light/board_manager.py
/usr/lib/python3/dist-packages/tuxedo_tomte_light/config_parser.py
/usr/lib/python3/dist-packages/tuxedo_tomte_light/fatal_handling.py
/usr/lib/python3/dist-packages/tuxedo_tomte_light/file_operations.py
/usr/lib/python3/dist-packages/tuxedo_tomte_light/hardware_parser.py
/usr/lib/python3/dist-packages/tuxedo_tomte_light/logging.py
/usr/lib/python3/dist-packages/tuxedo_tomte_light/package_manager.py
/usr/lib/python3/dist-packages/tuxedo_tomte_light/package_mapper.py
/usr/lib/python3/dist-packages/tuxedo_tomte_light/state_manager.py
/usr/lib/python3/dist-packages/tuxedo_tomte_light/tuxedo_detection.py
/usr/lib/python3/dist-packages/tuxedo_tomte_light/update_hardware_information.py
/usr/lib/python3/dist-packages/tuxedo_tomte_light-1.0.0.dist-info/METADATA
/usr/lib/python3/dist-packages/tuxedo_tomte_light-1.0.0.dist-info/WHEEL
/usr/lib/python3/dist-packages/tuxedo_tomte_light-1.0.0.dist-info/top_level.txt
/usr/lib/python3/dist-packages/tuxedo_tomte_light-1.0.0.dist-info/RECORD



%post
SPC_PKG_NAME="tuxedo-tomte-light"
SPC_PKG_VERSION="1.0.0"



# AUTOMATICALLY GENERATED POST-INSTALL CODE


# SPC: Autogenerated systemd setup
systemctl daemon-reload
systemctl enable tuxedo-tomte-light.timer
# Restart also starts not running units (ignore failures during installation)
systemctl restart tuxedo-tomte-light.timer > /dev/null || true



# END OF AUTOMATICALLY GENERATED POST-INSTALL CODE


%preun
SPC_PKG_NAME="tuxedo-tomte-light"
SPC_PKG_VERSION="1.0.0"



# AUTOMATICALLY GENERATED PRE-REMOVE CODE


# SPC: Autogenerated systemd update
# Stop all units
systemctl stop tuxedo-tomte-light.service > /dev/null || true
systemctl stop tuxedo-tomte-light.timer > /dev/null || true
# Disable all enabled units
systemctl disable tuxedo-tomte-light.timer > /dev/null


find /usr/lib/python3/spc-packages/tuxedo_tomte_light -type d -name '__pycache__' -exec rm -r {} +
find /usr/lib/python3/dist-packages/tuxedo_tomte_light -type d -name '__pycache__' -exec rm -r {} +
# END OF AUTOMATICALLY GENERATED PRE-REMOVE CODE


%postun
SPC_PKG_NAME="tuxedo-tomte-light"
SPC_PKG_VERSION="1.0.0"



# AUTOMATICALLY GENERATED POST-REMOVE CODE
# SPC: Autogenerated systemd update
systemctl daemon-reload

# END OF AUTOMATICALLY GENERATED POST-REMOVE CODE


%changelog
* Wed Jan 28 2026 Maximilian Arnold <tux@tuxedocomputers.com> - 1.0.0-1
- Hardened Python codebase and test infrastructure
- Added tuxedo-repository and tuxedo-suite as dependencies/recommended packages
- Fixed uncaught exit code in the install function
- Introduced separate logging for package installation history and program invocations
* Thu Dec 04 2025 Maximilian Arnold <tux@tuxedocomputers.com> - 0.2.0-1
- Add full functionality
* Fri Nov 07 2025 Aaron Erhardt <tux@tuxedocomputers.com> - 0.1.0-1
- Initial packaging
